######################################################################################################################
'''
列名	中文名	别名	类型	单位	默认值	是否可空	说明
SecuCode	证券代码		varchar(10)			FALSE	
SecuAbbr	证券简称		nvarchar(40)			TRUE	
SecuMarket	证券市场		varchar(12)			TRUE	
TradeDate	交易日期		datetime			FALSE	
TradeStatus	交易状态		char(1)			TRUE	
PreClosePrice	昨收		numeric(20,4)	元		TRUE	
OpenPrice	今开盘		numeric(20,4)	元		TRUE	
ClosePrice	今收盘		numeric(20,4)	元		TRUE	
HighPrice	最高价		numeric(20,4)	元		TRUE	
LowPrice	最低价		numeric(20,4)	元		TRUE	
TurnoverVolume	成交量		numeric(20,4)	手		TRUE	
TurnoverValue	成交额		numeric(20,4)	元		TRUE	
TurnoverDeals	成交笔数		numeric(20,4)	笔		TRUE	
Amplitude	振幅		numeric(20,4)	%		TRUE	
ChangeRatio	日涨跌幅		numeric(20,4)	%		TRUE	
FlowShares	流通股本		numeric(30,4)			TRUE	
FlowMarketValue	流通市值		numeric(30,4)			TRUE	
TotalEquity	公司总股本		numeric(20,4)			TRUE	
IssueEquity	发行总股本		numeric(30,4)			TRUE	
TotalValue	总市值		numeric(30,4)			TRUE	
RecordID	记录ID		uniqueidentifier		(newid())	TRUE	
RiseOrDown	涨跌标示		varchar(2)			TRUE	1：涨停 -1：跌停 0：无涨跌停
'''
class Stock():
    def __init__(self):
        pass
    '''
    def __init__(self,SecuCode,SecuAbbr,SecuMarket,TradeDate,TradeStatus,PreClosePrice,OpenPrice,ClosePrice,HighPrice,
        LowPrice,TurnoverVolume,TurnoverValue,TurnoverDeals,Amplitude,ChangeRatio,FlowShares,FlowMarketValue,TotalEquity,IssueEquity,
        TotalValue,RecordID,LLimitUpTime,RiseOrDown):
        self.SecuCode = SecuCode         	
        self.SecuAbbr = SecuAbbr     	
        self.SecuMarket = SecuMarket     
        self.TradeDate = TradeDate     	
        self.TradeStatus = TradeStatus     
        self.PreClosePrice = PreClosePrice     
        self.OpenPrice = OpenPrice     	
        self.ClosePrice = ClosePrice     
        self.HighPrice = HighPrice     	
        self.LowPrice = LowPrice     	
        self.TurnoverVolume = TurnoverVolume     
        self.TurnoverVal = TurnoverValue     
        self.TurnoverDeals = TurnoverDeals     
        self.Amplitude = Amplitude     	
        self.ChangeRatio = ChangeRatio     
        self.FlowShares = FlowShares     
        self.FlowMarketValue = FlowMarketValue     
        self.TotalEquity = TotalEquity     
        self.IssueEquity = IssueEquity     
        self.TotalValue = TotalValue     
        self.RecordID = RecordID     	
        self.LLimitUpTime = LLimitUpTime
        self.RiseOrDown = RiseOrDown  
        
    '''
    def printMe(self):
        print('this is stock!')
        print(self.SecuCode,self.SecuAbbr,self.TradeDate)
########################################################################################################################
'''
EMMIDD2.dbo.CY_ValueDaily_Quote

列名	中文名	别名	类型	单位	默认值	是否可空	说明
SecuCode	证券代码		varchar(12)			FALSE	
SecuAbbr	证券名称		nvarchar(40)			TRUE	
ReportPeriod	报告期		datetime			TRUE	
TradeDate	交易日期		datetime			FALSE	

PE1	市盈率(TTM)		numeric(14,4)	倍		TRUE	市盈率(TTM)
PB	市净率		numeric(14,4)	倍		TRUE	
PS	市销率		numeric(14,4)	倍		TRUE	

ClosePrice	最新收盘价		numeric(12,4)	元		TRUE	
RMBShares	最新流通A股		numeric(18,4)	万股		TRUE	
ValidShares	最新有效流通股		numeric(18,4)	万股		TRUE	扣除了非有效流通股数据
MarketValue	最新总市值		numeric(18,4)	元		TRUE	

'''
class ValueDaily():
    def __init__(self):
        pass
    '''
    def __init__(self,SecuCode,SecuAbbr,TradeDate,ReportPeriod,PE1,PB,PS,ClosePrice,RMBShares,Bshares,ValidShares,MarketValue):
        self.SecuCode = SecuCode         	
        self.SecuAbbr = SecuAbbr
        self.TradeDate = TradeDate
        self.ReportPeriod = ReportPeriod
        self.PE1 = PE1
        self.PB = PB
        self.PS = PS
        self.ClosePrice = ClosePrice
        self.RMBShares = RMBShares
        self.ValidShares = ValidShares
        self.MarketValue = MarketValue     
    '''
    def printMe(self):
        print(self.SecuCode,self.SecuAbbr,self.TradeDate)

###########################################################################################################################################
'''
列名	中文名	别名	类型	单位	默认值	是否可空	说明
SecuCode	证券代码		varchar(10)			FALSE	
SecuAbbr	证券简称		nvarchar(40)			TRUE	
TradeDate	交易日期		datetime			FALSE	
TradeStatus	交易状态		char(1)			TRUE	
PreClosePrice	昨收		numeric(20,4)	元		TRUE	
OpenPrice	今开盘		numeric(20,4)	元		TRUE	
ClosePrice	今收盘		numeric(20,4)	元		TRUE	
HighPrice	最高价		numeric(20,4)	元		TRUE	
LowPrice	最低价		numeric(20,4)	元		TRUE	
TurnoverVolume	成交量		numeric(20,4)	手		TRUE	
TurnoverValue	成交额		numeric(20,4)	元		TRUE	
TurnoverDeals	成交笔数		numeric(20,4)	笔		TRUE		
ChangeRatio	日涨跌幅		numeric(20,4)	%		TRUE	
'''
class Index():
    def __init__(self):
        pass
    '''
    def __init__(self,SecuCode,SecuAbbr,SecuMarket,TradeDate,TradeStatus,PreClosePrice,OpenPrice,ClosePrice,HighPrice,
        LowPrice,TurnoverVolume,TurnoverValue,TurnoverDeals,Amplitude,ChangeRatio,FlowShares,FlowMarketValue,TotalEquity,IssueEquity,
        TotalValue,RecordID,RiseOrDown):
        self.SecuCode = SecuCode         	
        self.SecuAbbr = SecuAbbr     	
        self.TradeDate = TradeDate      	
        self.TradeStatus = TradeStatus     
        self.PreClosePrice = PreClosePrice     
        self.OpenPrice = OpenPrice     	
        self.ClosePrice = ClosePrice     
        self.HighPrice = HighPrice     	
        self.LowPrice = LowPrice     	
        self.TurnoverVolume = TurnoverVolume     
        self.TurnoverValue = TurnoverValue  
        self.TurnoverDeals = TurnoverDeals  
        self.ChangeRatio = ChangeRatio     
    '''
    def printMe(self):
        print(self.SecuCode,self.SecuAbbr,self.TradeDate)

###########################################################################################################################################
'''
EMMIDD2.dbo.CY_FinacialRatio_RP

SecuCode	证券代码		varchar(12)			FALSE	
SecuAbbr	证券名称		nvarchar(40)			TRUE	
EndDate	报告日期		datetime			FALSE	
PublDate	公告日期		datetime			TRUE	
InventoryTurnover	存货周转率		numeric(18,4)	次		TRUE	
AccountsReceivableTurnover	应收账款周转率		numeric(18,4)	次		TRUE	
FixedAssetsTurnover	固定资产周转率		numeric(18,4)	次		TRUE	
OperatingRevenueYoY	主营收入同比		numeric(18,4)			TRUE	
DeductNetProfitYoY	归属于母公司股东的扣除非经常性损益后的净利润同比		numeric(18,4)			TRUE		

'''

class FinancialRatioRP():
    def __init__(self):
        pass
    '''
    def __init__(self,SecuCode,SecuAbbr,TradeDate,ReportPeriod,PE1,PB,PS,ClosePrice,RMBShares,Bshares,ValidShares,MarketValue):
        self.SecuCode = SecuCode         	
        self.SecuAbbr = SecuAbbr
        self.EndDate = EndDate
        self.PublDate = PublDate
        self.InventoryTurnover = InventoryTurnover
        self.AccountsReceivableTurnover = AccountsReceivableTurnover
        self.FixedAssetsTurnover = FixedAssetsTurnover
        self.OperatingRevenueYoY = OperatingRevenueYoY
        self.DeductNetProfitYoY = DeductNetProfitYoY

    '''
    def printMe(self):
        print(self.SecuCode,self.SecuAbbr,self.EndDate,self.DeductNetProfitYoY)

##########################################################################################################################
'''

EMMIDD2.dbo.CY_FinacialIndicators_RP

列名	中文名	别名	类型	单位	默认值	是否可空	说明
SecuCode	证券代码		varchar(12)			FALSE	
SecuAbbr	证券名称		nvarchar(40)			TRUE	
EndDate	报告日期		datetime			FALSE	
TotalAssets	总资产		numeric(18,4)	元		TRUE	
AdvanceReceipts	预收款项		numeric(18,4)			TRUE	
EquityBelongedToPC	净资产		numeric(18,4)			TRUE	
PublDate	公告日期		datetime			TRUE	
TotalLiability	总负债		numeric(18,4)	元		TRUE	
TotalCurrentLiability	流动负债		numeric(18,4)	元		TRUE	
TotalCurrentAssets	流动资产		numeric(18,4)	元		TRUE	
CashOrDepositInCentralBank	现金及存放中央银行款项		numeric(18,4)	元		TRUE	
NetProfit	净利润		numeric(18,4)	元		TRUE	
NetOperateCashFlow	经营活动产生的现金流		numeric(18,4)	元		TRUE	


'''

class FinancialIndicator():
    def __init__(self):
        pass
    '''
    def __init__(self,SecuCode,SecuAbbr,TradeDate,ReportPeriod,PE1,PB,PS,ClosePrice,RMBShares,Bshares,ValidShares,MarketValue):
        self.SecuCode = SecuCode         	
        self.SecuAbbr = SecuAbbr
        self.EndDate = EndDate
        self.PublDate = PublDate
        self.TotalCurrentAssets = TotalCurrentAssets
        self.TotalAssets = TotalAssets
        self.AdvanceReceipts = AdvanceReceipts
        self.EquityBelongedToPC = EquityBelongedToPC
        self.CashOrDepositInCentralBank = CashOrDepositInCentralBank
        self.TotalLiability = TotalLiability
        self.TotalCurrentLiability = TotalCurrentLiability
        self.NetProfit = NetProfit
        self.NetOperateCashFlow = NetOperateCashFlow


    '''
    def printMe(self):
        print(self.SecuCode,self.SecuAbbr,self.EndDate)
