# -*- coding: utf-8 -*-
"""
Created on 20180309

@author: zhoushuai
"""
'''
估值指标 （EMMIDD2.dbo.CY_ValueDaily_Quote）											
	PE(TTM)	最新一期/最近一年/最近三年	小于10	10~15	15~20	20~40	40~60	60~80	80~100	大于100	小于0
	PB	最新一期/最近一年/最近三年	小于1	1~1.5	1.5~2	2~2.5	2.5~3.5	3.5~5	大于5		
	PS	最新一期/最近一年/最近三年	大于10	10~5	5~3	3~1	1~0	小于0			
	PE预测	最新一期/最近一年/最近三年	小于10	10~15	15~20	20~40	40~60	60~80	80~100	大于100	小于0
	股息率	最新一期/最近一年/最近三年	大于5%	5%~3%	3%~1%	小于1%					
市值指标 （EMMIDD2.dbo.CY_ValueDaily_Quote）											
	总市值	最新一期/最近一年/最近三年	巨盘	大盘	中盘	小盘	微盘				
	流通市值	最新一期/最近一年/最近三年	巨盘	大盘	中盘	小盘	微盘				
	有效流通市值	最新一期/最近一年/最近三年	巨盘	大盘	中盘	小盘	微盘				
			大于1000亿	500~1000亿	200~500亿	50~200亿	小于50亿				

最新一期：这个季度和上个季度相比
最近一年：今年和去年相比
最近三年：今年和前年相比

watch this out      
                   Tradedate               ReportedPeriod                                    
600000	浦发银行	2017-12-27 00:00:00.000	2017-09-30 00:00:00.000	1.45000000
600000	浦发银行	2017-12-28 00:00:00.000	2017-09-30 00:00:00.000	1.45000000
600000	浦发银行	2017-12-29 00:00:00.000	2017-09-30 00:00:00.000	1.45000000
600000	浦发银行	2018-01-02 00:00:00.000	2017-12-31 00:00:00.000	1.84000000
600000	浦发银行	2018-01-03 00:00:00.000	2017-12-31 00:00:00.000	1.84000000
600000	浦发银行	2018-01-04 00:00:00.000	2017-12-31 00:00:00.000	1.84000000

2018-01-02 is the most recently updated date, get the data of this day,

方大炭素10-30号公布财报，这一天是财报的
                    TradeDate               ReportedPeriod                     PE1
600516	方大炭素	2017-10-26 00:00:00.000	2017-06-30 00:00:00.000	.23024118	106.1764	59.8503	7.5299
600516	方大炭素	2017-10-27 00:00:00.000	2017-06-30 00:00:00.000	1.16400000	103.4796	11.8980	7.3386
600516	方大炭素	2017-10-30 00:00:00.000	2017-09-30 00:00:00.000	1.16400000	24.9367	18.5979	6.0679
600516	方大炭素	2017-10-31 00:00:00.000	2017-09-30 00:00:00.000	1.16400000	25.9524	19.3553	6.3150
600516	方大炭素	2017-11-01 00:00:00.000	2017-09-30 00:00:00.000	1.16400000	25.8366	19.2690	6.2868

原来9-30号是最新的一期，那我就只要用ReportedPeried的第一个03-31，06-30，09-30，12-31

PE（TTM）最近三年小于10
简单的来处理，就取三个时间点就好了，因为净利润一年只可能知道4次，那么准确的PE其实也只有4个点的值而已。
因为不可能知道企业每一天的净利，所以平时滚动的PE其实也是大家的不准确估计吧
'''
import pandas as pd
import pyodbc
import ky
import datetime

sdk = ky.Api("http://data-api.kuaiyutech.com/api.rpc")

import logging
logger = logging.getLogger(__name__)
try:
    from ..BT.value import Value
    from ..BT.index import Index 
    logger.setLevel(logging.CRITICAL)
    from ..util.kySDK import *
    from .apiParent import ApiParent
except:
    import sys   
    sys.path.insert(0, 'D:/Project/YM/BackTesting Frame/KYBT/BT') 
    sys.path.insert(0, 'D:/Project/YM/BackTesting Frame/KYBT/util')
    print(sys.path)
    from value import Value 
    from index import Index
    from kySDK import *
    from apiParent import ApiParent
    logger.setLevel(logging.WARNING)


class API(ApiParent):

    def __init__(self,DSN): 
        super().__init__(DSN)
    
    @staticmethod
    def pdToValueObjectList(panda):
        valueList = []
        for index,row in panda.iterrows():
            oneValue = Value()
            oneValue.SecuCode = row['SecuCode']         	
            oneValue.SecuAbbr = row['SecuAbbr']
            oneValue.TradeDate = row['TradeDate']
            oneValue.ReportPeriod = row['ReportPeriod']
            oneValue.PE1 = float(row['PE1'])
            oneValue.PB = float(row['PB'])
            oneValue.PS = float(row['PS'])
            oneValue.ClosePrice = float(row['ClosePrice'])
            oneValue.RMBShares = float(row['RMBShares'])
            oneValue.ValidShares = float(row['ValidShares'])
            oneValue.MarketValue = float(row['MarketValue']) 
            valueList.append(oneValue)
        return valueList

    def getSpotValue(self,startDate,endDate,stockList):
        '''
        CY_ValueDaily_Quote is daily data
        stock: list, ## [600000,000002]
        startDate: str, '2018-01-10'
        endDate: str,'2018-03-03' 
        '''
        #    
        itemString = '''
                SecuCode,
                SecuAbbr,
                TradeDate,
                ReportPeriod,
                EPS,
                PE1,
                PE2,
                PB,
                PS,
                Dividend1Y,
                MarketValue,
                ClosePrice,
                ValidShares,
                RMBShares,
                Bshares'''
        #
        if len(stockList) == 1:
            stockList = '(%s)'%stockList[0]
        else:
            stockList = tuple(stockList)
        #
        query = '''
            SELECT
                %s
            FROM
                [dbo].[CY_ValueDaily_Quote]
            where 
            TradeDate <= '%s 00:00:00:000'
            AND 
            TradeDate >= '%s 00:00:00:000'
            AND SecuCode IN %s
            ORDER BY
                SecuAbbr DESC,
                TradeDate Asc
        '''%(itemString,endDate,startDate,stockList)
        #
        #print(query)
        self.cursor.execute(query)

        raw = self.cursor.fetchall()
        logger.info('raw :',raw)

        if not raw:
            logger.critical( 'CY_ValueDaily_Quote value has no data, return None')
            return None
        
        valuePD = self.pandaData(raw,itemString)
        valuePD.fillna(value=0, inplace=True) # to replace None with value 0
        return self.pdToValueObjectList(valuePD)


if __name__ == '__main__':
    logger.warn(__file__)
    myAPI = API('BTEMmidd2')
    myAPI.init()
    y = myAPI.getSpotValue('2017-05-05','2017-06-06',['600000'])
    print(y)