# -*- coding: utf-8 -*-
"""

Created on 20180313

@author: Matthew
"""
from numpy import prod

class Position():
    '''
    each stock that was being bought has a position,
    one stock is matched with one position,
    account can have 0 to multiple positions, 
    one stock can remain in position for 5 days, so this position has a recored of this stock object of 5 days
    it is easier this way to calculate the real growth or drop-down over a certain period.
    after sold it, position is cleared, position is not in account as well

    '''
    def __init__(self,stock,boughtAmount,price):
        
        self.stock = stock
        self.TradeDate = stock.TradeDate
        self.boughtAmount = boughtAmount
        self.SecuCode = stock.SecuCode
        self.boughtPrice = price
        self.initialValue = boughtAmount * price
        self.positionValue = self.initialValue
        self.TradeStatus = stock.TradeStatus
        self.PreClosePrice = stock.PreClosePrice
        self.ClosePrice = stock.ClosePrice
        self.RiseOrDown = stock.RiseOrDown

        #entering account 
        self.isinAccount = True
        self.remainRecord = [stock]

    def leaveAccount(self):
        self.isinAccont = False
        self.remainRecord.clear()

    def remainInAccount(self,stock,method):
        '''
        method 1|2 to update the Real positionValue using method 1 or 2
        '''
        self.remainRecord.append(stock)
        #print([x.SecuCode for x in self.remainRecord])
        #print([x.ClosePrice for x in self.remainRecord])
        #print([type(x.TradeStatus) for x in self.remainRecord])
        #print([x.PreClosePrice for x in self.remainRecord])
        if method == 1:
            self.updatePositionValueMethod1()
        elif method == 2:
            self.updatePositionValueMethod2()

    def updatePositionValueMethod1(self):
        '''
        买入的价格是买入的总市值除以买入时候的股本，用当前总市值除以买入时候的股本，就得到今日的价格，
        当然这个价格和实际的而价格肯定不一样，但是要算涨幅的话是绰绰有余了。
        
        参考浦发银行
        
        同花顺的价格：
        除权 
        2015-05-05  17.08 
        2018-03-15  12.38 
        前复权
        2015-05-05 10.09 
        2018-03-15 12.39 
        实际涨幅为 (12.39-10.09)/10.09 = 22.79%

        益盟的复权价格： 
        2015-05-05 FClosePrice 119.4343
        2018-03-15 FClosePrice 127.8294
        涨幅是 7.029% 

        Method 1 
        2015-05-05 总股本 18653471488.0000 总市值 318601293015.0000
        2018-03-15 总股本 29352079872.0000 总市值 363672269614.0000   

        按照Method1 涨幅为 (318601293015.0000/18653471488.0000 - 363672269614.0000/18653471488.0000) 除以 363672269614.0000/18653471488.0000
        = ( 318601293015.0000 - 363672269614.0000 ) / 363672269614.0000
        = 14.14% 

        可以看出 this is obviously Wrong.... 涨幅不是总市值的涨幅
        
        比较准确的算法：Method2
        可以知道每日的涨幅，用(Close-PreClose)PreClose,然后用买入价格*(1+涨幅)*(1+涨幅).... 算出今日的价格，然后算出整个事件窗口的涨幅，
        记得要剔除无法交易的日子。这样算出来的涨幅是6.14%
        
        记得今日的涨幅是昨收和今收的涨幅，而不是今收和今收的涨幅，所以涨幅一定是某日收盘价和基准日的昨收价格比较
        
        
        ''' 
        initial = self.remainRecord[0]
        current =  self.remainRecord[-1]

        initialPrice = initial.TotalValue/initial.TotalEquity
        currentPrice = current.TotalValue/initial.TotalEquity
        #print('initialPrice.TotalValue,initialPrice.TotalEquity',initial.TotalValue,' ',initial.TotalEquity)
        #print('current.TotalValue,current.TotalEquity',current.TotalValue,' ',current.TotalEquity)
        #print('initialPrice,currentPrice',initialPrice,' ',currentPrice)
        growth = (currentPrice - initialPrice) / initialPrice
        #print('method 1 growth', growth)
        self.positionValue = self.positionValue * ( 1 + growth)

    def updatePositionValueMethod2(self):
        '''
        [12,11,13,6]  just sum the changeRatio of each day, don't need to consider 除权 issue
        假设所有的涨幅都按照( 今收-昨收/昨收) 来算，其实现实可能不是这样，如果今开买入，涨幅显然就不同了
        '''
        changeReal = []
        for x in self.remainRecord[:-1]: # 
            #print(type(x),x.__dict__)
            if x.TradeStatus == '1':
                if x.PreClosePrice == 0:
                    changeReal.append(  1 + x.ChangeRatio )
                else:
                    changeReal.append(  1 + (x.ClosePrice - x.PreClosePrice)/x.PreClosePrice )
        #print('changeReal',changeReal)
        #print([x.ChangeRatio for x in self.remainRecord])
        #print('method 2 growth', growth)
        #记得今日的涨幅是昨收和今收的涨幅，而不是今收和今收的涨幅，所以涨幅一定是某日收盘价和基准日的昨收价格比较
        #print('changeReal',changeReal)
        #print('prod(changeReal)', prod(changeReal),' len: ',len(changeReal))
        self.positionValue = self.initialValue * prod(changeReal)
        

    def updatePositionValue(self,stock,tradingHabit):
        self.positionValue = self.boughtAmount * stock.OpenPrice if tradingHabit == 'OpenPrice' else self.boughtAmount * stock.ClosePrice
    

    def getPositionValue(self):
        return self.positionValue








