# try thread and multiprocess on YMDB

from KYBT.API import marketValueAPI

portforlio = ['600000','000002','600485'] # 'all'|'HS300'|'SZ500'|'SZ50'|['600000','000002',...] 
portforlio = 'all'
stockID = '300357'
startDate = '2014-01-10'
endDate = '2018-11-01'

sdk = marketValueAPI.API()
data1 = sdk.getMarketValueOneStock(startDate,endDate,stockID)
data2 = sdk.getMarketValueOneDay(startDate,portforlio)


from multiprocessing import Pool
import os, time, random

def getData(name):
    print('Run task %s (%s)...' % (name, os.getpid()))
    sdk = marketValueAPI.API()
    data1 = sdk.getMarketValueOneStock(startDate,endDate,stockID)
    data2 = sdk.getMarketValueOneDay(startDate,portforlio)
    #print(data2)

def long_time_task(name):
    print('Run task %s (%s)...' % (name, os.getpid()))
    start = time.time()
    time.sleep(random.random() * 3)
    end = time.time()
    print('Task %s runs %0.2f seconds.' % (name, (end - start)))

if __name__=='__main__':
    print('Parent process %s.' % os.getpid())
    p = Pool()
    for i in range(5):
        p.apply_async(long_time_task, args=(i,))
        #p.apply_async(getData, args=(i,))
    print('Waiting for all subprocesses done...')
    p.close()
    p.join()
    print('All subprocesses done.')




